function graph(obj,x,rho)
% GRAPH reprsente graphiquement une marche d'nergie potentielle
%   ainsi que la densit de probabilit d'un objet physique interagissant avec
%   cette marche
%   GRAPH(obj,x,varargin)
%       >> obj      = Objet informatique marche;
%       >> x        = Variable de position sur l'axe x;
%       >> rho      = Densit linique de probabilit;
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (isa(obj,'marche')==0),error('Mauvais type d''objet !');end
%
xmin=x{1}(1);
xmax=x{2}(end);
if ( (xmin>=obj.x)||(xmax<=obj.x) ),error('La marche est hors du domaine !');end
Epmin=min(obj.Epe,obj.Eps);
Epmax=max(obj.Epe,obj.Eps);

%% Trac graphique

figure

subplot(2,1,1);
hs=stairs([xmin obj.x xmax],[obj.Epe obj.Eps obj.Eps]);
set(hs,'LineWidth',2,'Color','b');grid on;box on;
axis([xmin xmax Epmin-.2 Epmax+.2]);
grid on;
box on;
set(gca,'Xminortick','on','Yminortick','on');
xlabel('{\itx} (nm)');
title('Energie potentielle (eV)');
%
subplot(2,1,2);
hp=plot(x{1},rho{1},x{2},rho{end});
set(hp,'LineWidth',2,'Color','r');
axis auto;
grid on;
box on;
set(gca,'Xminortick','on','Yminortick','on');
xlabel('{\itx} (nm)');
title('{\it{\rho_p}}');
%
return;